/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.client.CustomDataRenderer;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryCustomRendererComponent;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryItemCosmeticOverride;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.components.AccessoryStackSizeComponent;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.commands.RecordArgumentTypeInfo;
import io.wispforest.accessories.commands.ResourceExtendedArgument;
import io.wispforest.accessories.commands.SlotArgumentType;
import io.wispforest.accessories.data.CustomRendererLoader;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2287;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class AccessoriesCommands {
    public static final SimpleCommandExceptionType NON_LIVING_ENTITY_TARGET = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.livingEntities.nonLiving"));
    public static final SimpleCommandExceptionType INVALID_SLOT_TYPE = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid Slot Type"));
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType((var1, var2, var3) -> class_2561.method_54159((String)"commands.attribute.failed.modifier_already_present_itemstack", (Object[])new Object[]{var1, var2, var3}));
    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType((var1, var2, var3) -> class_2561.method_54159((String)"commands.attribute.failed.no_modifier_itemstack", (Object[])new Object[]{var1, var2, var3}));

    public static void registerCommandArgTypes() {
        AccessoriesInternals.registerCommandArgumentType(Accessories.of("slot_type"), SlotArgumentType.class, RecordArgumentTypeInfo.of(ctx -> SlotArgumentType.INSTANCE));
        AccessoriesInternals.registerCommandArgumentType(Accessories.of("resource"), ResourceExtendedArgument.class, RecordArgumentTypeInfo.of(ResourceExtendedArgument::attributes));
    }

    public static class_1309 getOrThrowLivingEntity(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(ctx, (String)"entity");
        if (!(entity instanceof class_1309)) {
            throw NON_LIVING_ENTITY_TARGET.create();
        }
        class_1309 livingEntity = (class_1309)entity;
        return livingEntity;
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 context) {
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)class_2170.method_9247((String)"accessories").requires(commandSourceStack -> commandSourceStack.method_9259(2));
        if (Accessories.DEBUG) {
            ((LiteralArgumentBuilder)base.then(class_2170.method_9247((String)"create-renderer-stack").then(class_2170.method_9244((String)"custom_name", (ArgumentType)class_2178.method_9281((class_7157)context)).then(class_2170.method_9244((String)"renderer_id", (ArgumentType)class_2232.method_9441()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"item_model_id", (ArgumentType)class_2232.method_9441()).then(class_2170.method_9244((String)"is_bundle", (ArgumentType)BoolArgumentType.bool()).executes(AccessoriesCommands::createRenderStack))).executes(AccessoriesCommands::createRenderStack)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"listen-to-renderer").then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).executes(ctx -> {
                class_2960 id = (class_2960)ctx.getArgument("id", class_2960.class);
                CustomRendererLoader.constantFileResolving(((class_2168)ctx.getSource()).method_9211(), id);
                return 1;
            }))).executes(ctx -> {
                CustomRendererLoader.constantFileResolving(((class_2168)ctx.getSource()).method_9211(), null);
                return 1;
            }));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"edit").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(ctx -> {
            Accessories.askPlayerForVariant(((class_2168)ctx.getSource()).method_9207(), AccessoriesCommands.getOrThrowLivingEntity((CommandContext<class_2168>)ctx));
            return 1;
        }))).executes(ctx -> {
            Accessories.askPlayerForVariant(((class_2168)ctx.getSource()).method_9207());
            return 1;
        }))).then(class_2170.method_9247((String)"nest").then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)context)).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            class_1799 stack = player.method_6047();
            class_1799 innerStack = class_2287.method_9777((CommandContext)ctx, (String)"item").method_9781(1, false);
            stack.method_57368(AccessoriesDataComponents.NESTED_ACCESSORIES, (Object)AccessoryNestContainerContents.EMPTY, data -> data.addStack(innerStack));
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"slot").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9247((String)"valid").then(class_2170.method_9244((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(0, (class_1309)((class_2168)ctx.getSource()).method_9207(), (CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"invalid").then(class_2170.method_9244((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(1, (class_1309)((class_2168)ctx.getSource()).method_9207(), (CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9247((String)"valid").then(class_2170.method_9244((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(2, (class_1309)((class_2168)ctx.getSource()).method_9207(), (CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"invalid").then(class_2170.method_9244((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(3, (class_1309)((class_2168)ctx.getSource()).method_9207(), (CommandContext<class_2168>)ctx))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stack-sizing").then(class_2170.method_9247((String)"useStackSize").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            Boolean bl = (Boolean)ctx.getArgument("value", Boolean.class);
            player.method_6047().method_57368(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT, component -> component.useStackSize(bl));
            return 1;
        })))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            Integer size = (Integer)ctx.getArgument("value", Integer.class);
            player.method_6047().method_57368(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT, component -> component.sizeOverride(size));
            return 1;
        })))).then(class_2170.method_9247((String)"attribute").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"modifier").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"attribute", ResourceExtendedArgument.attributes(context)).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).then(AccessoriesCommands.createAddLiteral("add_value"))).then(AccessoriesCommands.createAddLiteral("add_multiplied_base"))).then(AccessoriesCommands.createAddLiteral("add_multiplied_total"))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"attribute", ResourceExtendedArgument.attributes(context)).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).executes(ctx -> AccessoriesCommands.removeModifier((class_2168)ctx.getSource(), (class_1309)((class_2168)ctx.getSource()).method_9207(), ResourceExtendedArgument.getAttribute((CommandContext<class_2168>)ctx, "attribute"), class_2232.method_9443((CommandContext)ctx, (String)"id"))))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"attribute", ResourceExtendedArgument.attributes(context)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).executes(ctx -> AccessoriesCommands.getAttributeModifier((class_2168)ctx.getSource(), (class_1309)((class_2168)ctx.getSource()).method_9207(), ResourceExtendedArgument.getAttribute((CommandContext<class_2168>)ctx, "attribute"), class_2232.method_9443((CommandContext)ctx, (String)"id"), 1.0))).then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> AccessoriesCommands.getAttributeModifier((class_2168)ctx.getSource(), (class_1309)((class_2168)ctx.getSource()).method_9207(), ResourceExtendedArgument.getAttribute((CommandContext<class_2168>)ctx, "attribute"), class_2232.method_9443((CommandContext)ctx, (String)"id"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"scale")))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"log").then(class_2170.method_9247((String)"slots").executes(ctx -> {
            LOGGER.info("All given Slots registered:");
            for (SlotType slotType : SlotTypeLoader.getSlotTypes((class_1937)((class_2168)ctx.getSource()).method_9225()).values()) {
                LOGGER.info(slotType.toString());
            }
            return 1;
        }))).then(class_2170.method_9247((String)"groups").executes(ctx -> {
            LOGGER.info("All given Slot Groups registered:");
            for (SlotGroup group : SlotGroupLoader.getGroups((class_1937)((class_2168)ctx.getSource()).method_9225())) {
                LOGGER.info(group.toString());
            }
            return 1;
        }))).then(class_2170.method_9247((String)"entity_bindings").executes(ctx -> {
            LOGGER.info("All given Entity Bindings registered:");
            EntitySlotLoader.INSTANCE.getEntitySlotData(false).forEach((type, slots) -> LOGGER.info("[{}]: {}", type, slots.keySet()));
            return 1;
        }))));
    }

    private static LiteralArgumentBuilder<class_2168> createAddLiteral(String literal) {
        class_1322.class_1323 selectedValue = Arrays.stream(class_1322.class_1323.values()).filter(value -> value.method_15434().equals(literal)).findFirst().orElse(null);
        if (selectedValue == null) {
            throw new IllegalStateException("Unable to handle the given literal as its not a valid AttributeModifier Operation! [Literal: " + literal + "]");
        }
        return (LiteralArgumentBuilder)class_2170.method_9247((String)literal).then(class_2170.method_9244((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).then(class_2170.method_9244((String)"isStackable", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> AccessoriesCommands.addModifier((class_2168)ctx.getSource(), (class_1309)((class_2168)ctx.getSource()).method_9207(), ResourceExtendedArgument.getAttribute((CommandContext<class_2168>)ctx, "attribute"), class_2232.method_9443((CommandContext)ctx, (String)"id"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value"), selectedValue, SlotArgumentType.getSlot((CommandContext<class_2168>)ctx, "slot"), BoolArgumentType.getBool((CommandContext)ctx, (String)"isStackable")))));
    }

    private static int getAttributeModifier(class_2168 commandSourceStack, class_1309 livingEntity, class_6880<class_1320> holder, class_2960 resourceLocation, double d) throws CommandSyntaxException {
        class_1799 stack = livingEntity.method_6047();
        AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)stack.method_57825(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
        class_1322 modifier = component.getModifier(holder, resourceLocation);
        if (modifier == null) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)stack.method_7954(), (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)resourceLocation);
        }
        double e = modifier.comp_2449();
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"commands.attribute.modifier.value.get.success_itemstack", (Object[])new Object[]{class_2561.method_54154((class_2960)resourceLocation), AccessoriesCommands.getAttributeDescription(holder), stack.method_7954(), e}), false);
        return (int)(e * d);
    }

    private static int addModifier(class_2168 commandSourceStack, class_1309 livingEntity, class_6880<class_1320> holder, class_2960 resourceLocation, double d, class_1322.class_1323 operation, String slotName, boolean isStackable) throws CommandSyntaxException {
        class_1799 stack = livingEntity.method_6047();
        AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)stack.method_57825(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
        if (component.hasModifier(holder, resourceLocation)) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create((Object)resourceLocation, (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)stack.method_7954());
        }
        stack.method_57379(AccessoriesDataComponents.ATTRIBUTES, (Object)component.withModifierAdded(holder, new class_1322(resourceLocation, d, operation), slotName, isStackable));
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"commands.attribute.modifier.add.success_itemstack", (Object[])new Object[]{class_2561.method_54154((class_2960)resourceLocation), AccessoriesCommands.getAttributeDescription(holder), stack.method_7954()}), false);
        return 1;
    }

    private static int removeModifier(class_2168 commandSourceStack, class_1309 livingEntity, class_6880<class_1320> holder, class_2960 location) throws CommandSyntaxException {
        MutableBoolean removedModifier = new MutableBoolean(false);
        class_1799 stack = livingEntity.method_6047();
        stack.method_57368(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY, component -> {
            int size = component.modifiers().size();
            if (size != (component = component.withoutModifier(holder, location)).modifiers().size()) {
                removedModifier.setTrue();
            }
            return component;
        });
        if (!removedModifier.getValue().booleanValue()) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)location, (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)stack.method_7954());
        }
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"commands.attribute.modifier.remove.success_itemstack", (Object[])new Object[]{class_2561.method_54154((class_2960)location), AccessoriesCommands.getAttributeDescription(holder), stack.method_7954()}), false);
        return 1;
    }

    private static class_2561 getAttributeDescription(class_6880<class_1320> attribute) {
        return class_2561.method_43471((String)((class_1320)attribute.comp_349()).method_26830());
    }

    private static int adjustSlotValidationOnStack(int operation, class_1309 player, CommandContext<class_2168> ctx) {
        String slotName = SlotArgumentType.getSlot(ctx, "slot");
        player.method_6047().method_57368(AccessoriesDataComponents.SLOT_VALIDATION, (Object)AccessorySlotValidationComponent.EMPTY, component -> switch (operation) {
            case 0 -> component.addValidSlot(slotName);
            case 1 -> component.addInvalidSlot(slotName);
            case 2 -> component.removeValidSlot(slotName);
            case 3 -> component.removeInvalidSlot(slotName);
            default -> throw new IllegalStateException("Unexpected value: " + operation);
        });
        return 1;
    }

    private static int createRenderStack(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2960 rendererId = (class_2960)ctx.getArgument("renderer_id", class_2960.class);
        class_2960 modelId = (class_2960)ctx.getArgument("item_model_id", class_2960.class);
        class_2561 component = class_2178.method_9280(ctx, (String)"custom_name");
        class_1792 item = class_1802.field_8600;
        try {
            if (((Boolean)ctx.getArgument("is_bundle", Boolean.class)).booleanValue()) {
                item = class_1802.field_27023;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class_1799 itemStack = item.method_7854();
        itemStack.method_57379(class_9334.field_50239, (Object)component);
        itemStack.method_57379(AccessoriesDataComponents.CUSTOM_RENDERER, (Object)new AccessoryCustomRendererComponent(List.of(new CustomDataRenderer(rendererId, Map.of(), List.of(), null))));
        itemStack.method_57379(AccessoriesDataComponents.ITEM_MODEL_OVERRIDE, (Object)new AccessoryItemCosmeticOverride(modelId));
        itemStack.method_57379(AccessoriesDataComponents.SLOT_VALIDATION, (Object)new AccessorySlotValidationComponent(Set.of("any"), Set.of()));
        ((class_2168)ctx.getSource()).method_9207().method_7270(itemStack);
        return 1;
    }
}

